<?php

namespace App\Http\Controllers;
require 'vendor/autoload.php';

use Illuminate\Http\Request;
use Redirect;
use App\Order;
use App\BusinessSetting;
use App\Seller;
use Session;
use App\CustomerPackage;
use App\SellerPackage;


//if you want to change the namespace/path from 'PayMoney' - lines[1-5] - to your desired name,i.e. (use PayMoney\Api\Amount; to use MyDomain\Api\Amount;), then you must change the folders name that holds the API classes as well as change the property 'PayMoney' in (autoload->psr-0) of (php-sdk/composer.json) file to your desired name and run "composer dump-autoload" command from sdk root

use App\Africunia\Api\Amount;
use App\Africunia\Api\Payer;
use App\Africunia\Api\Payment;
use App\Africunia\Api\RedirectUrls;
use App\Africunia\Api\Transaction;
use App\Currency;
use Illuminate\Support\Facades\Auth;
class AfricuniaController extends Controller
{

public function makeCheckout()
{

if(Session::has('payment_type')){
            if(Session::get('payment_type') == 'cart_payment'){
                $order = Order::findOrFail(Session::get('order_id'));
                $amount = $order->grand_total;
            }
            elseif (Session::get('payment_type') == 'wallet_payment') {
                $amount = Session::get('payment_data')['amount'];
            }
            elseif (Session::get('payment_type') == 'customer_package_payment') {
                $customer_package = CustomerPackage::findOrFail(Session::get('payment_data')['customer_package_id']);
                $amount = $customer_package->amount;
            }
            elseif (Session::get('payment_type') == 'seller_package_payment') {
                $seller_package = SellerPackage::findOrFail(Session::get('payment_data')['seller_package_id']);
                $amount = $seller_package->amount;
            }
        }


if(Session::has('currency_code')){
                                $currency_code = Session::get('currency_code');
                            }
                            else{
                                $currency_code = isset(Auth::user()->currency) ? Auth::user()->currency : 'NGN';
                            } 
                            

         $mycur = Currency::where('status' , 1)->get();

         $mya = 0;

         foreach($mycur as $mc)
         {
            if($mc->code == $currency_code)
            {
                $currency_code = 'USD';
                $ee = $mc->exchange_rate;
                $mya = $amount / $ee ; 

                $amount = $mya;
            }
         }

        //Payer Object
$payer = new Payer();
$payer->setPaymentMethod('AFRICUNIA BANK Wallet'); //preferably, your system name, example - PayMoney

//Amount Object
$amountIns = new Amount();
$amountIns->setTotal($amount)->setCurrency('USD'); //must give a valid currency code and must exist in merchant wallet list

//Transaction Object
$trans = new Transaction();
$trans->setAmount($amountIns);

//RedirectUrls Object
$urls = new RedirectUrls();
$urls->setSuccessUrl('https://www.vendabuy.com/africunia/payment/done') //success url - the merchant domain page, to redirect after successful payment, see sample example-success.php file in sdk root, example - http://techvill.net/paymoney_sdk/example-success.php

->setCancelUrl('https://www.vendabuy.com/africunia/payment/cancel'); //cancel url - the merchant domain page, to redirect after cancellation of payment, example -  http://techvill.net/paymoney_sdk/


//Payment Object
$payment = new Payment();
$payment->setCredentials([ //Client ID & Secret = Merchants->setting(gear icon)
    'client_id'     => 'MlvQzFHXbjtwYVRAEKL3jTYjIjtuRN', //must provide correct client id of an express merchant
    'client_secret' => '2hChYXVCpLyrjIhRIXxOqONQR9ExF2Y4QUnH4VNhXejqsy47HY8supUJVcjBCjFni2Zz1G9VDt3ICCuSTLyVfSaA7p65w08NdcXh', //must provide correct client secret of an express merchant
])
->setRedirectUrls($urls)
->setPayer($payer)
->setTransaction($trans);

try {
    $payment->create(); //create payment
    header("Location: " . $payment->getApprovedUrl()); //checkout url
}
catch (\Exception $ex)
{
    print $ex;
    exit;
}
    }


    public function getCancel(Request $request)
    {
        // Curse and humiliate the user for cancelling this most sacred payment (yours)
        $request->session()->forget('order_id');
        $request->session()->forget('payment_data');
        flash(translate('Payment cancelled'))->success();
    	return redirect()->route('home');
    }

    public function getDone(Request $request)
    {

             $encoded = json_encode($_GET);
    // var_dump($encoded);
    // echo '<br/><br/>';

    $decoded = json_decode(base64_decode($encoded), TRUE);
            // If call returns body in response, you can get the deserialized version from the result attribute of the response
            if($request->session()->has('payment_type')){
                if($request->session()->get('payment_type') == 'cart_payment'){
                    $checkoutController = new CheckoutController;
                    return $checkoutController->checkout_done($request->session()->get('order_id'), json_encode($_GET));
                }
                elseif ($request->session()->get('payment_type') == 'wallet_payment') {
                    $walletController = new WalletController;
                    return $walletController->wallet_payment_done($request->session()->get('payment_data'), json_encode($decoded));
                }
                elseif ($request->session()->get('payment_type') == 'customer_package_payment') {$customer_package_controller = new CustomerPackageController;
                    return $customer_package_controller->purchase_payment_done($request->session()->get('payment_data'), json_encode($decoded));
                }
                elseif ($request->session()->get('payment_type') == 'seller_package_payment') {$seller_package_controller = new SellerPackageController;
                    return $seller_package_controller->purchase_payment_done($request->session()->get('payment_data'), json_encode($decoded));
                }
            }
        }


    
}
